package fr.asip.cps3.exemple.modele.exceptions;


/**
 * Classe d'exception applicative intervenant au niveau de la couche vue de l'applications
 */
public class ExceptionVue extends ExceptionProgrammeExemple {
	

	private static final long serialVersionUID = -6669896419721686949L;
	
	/**
	 * Code du type d'exception
	 */
	private int typeException = -1;
	
	/**
	 * Constructeur
	 * @param typeException Code du type d'exception
	 */
	public ExceptionVue(int typeException) {
		super();
		this.typeException = typeException;
	}

	/**
	 * Constructeur
	 * @param typeException Code du type d'exception 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionVue(int typeException, String message, Throwable cause) {
		super(message, cause);
		this.typeException = typeException;
	}

	/**
	 * Constructeur
	 * @param typeException Code du type d'exception 
	 * @param message Intitul de l'exception
	 */
	public ExceptionVue(int typeException, String message) {
		super(message);
		this.typeException = typeException;
	}

	/**
	 * Constructeur
	 * @param typeException Code du type d'exception 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionVue(int typeException, Throwable cause) {
		super(cause);
		this.typeException = typeException;
	}

	/**
	 * Dtermine le type d'exception
	 * @return Le type d'exception
	 */
	public String getTypeException() {
		
		switch(typeException) {
		
			case ExceptionProgrammeExemple.TYPE_VUE_EXCEPTION_AFFICHAGE_ECRAN:
				return ("Erreur affichage saisie");

			case ExceptionProgrammeExemple.TYPE_VUE_EXCEPTION_AFFICHAGE_RESULTAT:
				return ("Erreur affichage resultat");

			case ExceptionProgrammeExemple.TYPE_VUE_EXCEPTION_CONSTRUCTION_FENETRE:
				return ("Erreur construction de fentre");
				
			case ExceptionProgrammeExemple.TYPE_VUE_EXCEPTION_CONSTRUCTION_MENU:
				return ("Erreur construction menu");			
				
				
			default:
				return "Erreur affichage";
		}
			
	}
	
}
